'use strict';

/* --------------------------------------------------------------
 content_manager_preview.js 2017-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Content Manager Preview
 *
 * Controller Module to open preview modal
 *
 * Opens a modal with the preview of the selected Content Manager entry.
 */
gx.controllers.module('content_manager_preview', ['modal'], function (data) {

    'use strict';

    // --------------------------------------------------------------------
    // VARIABLES
    // --------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Preview modal.
     *
     * @type {jQuery}
     */
    var $modal = $('.preview.modal');

    /**
     * Open preview icon selector string.
     *
     * @type {String}
     */
    var openPreviewSelector = '.open-preview';

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // --------------------------------------------------------------------
    // FUNCTIONS
    // --------------------------------------------------------------------

    function _onPreviewClick(event) {
        event.preventDefault();

        // Iframe that should show the preview
        var $iframe = $modal.find('.modal-body iframe');

        // Id of the content that should be shown in preview modal
        var content_id = $(event.target).parents(openPreviewSelector).data('contentId');

        // Url of link element that should be shown in preview modal
        var link_url = $(event.target).parents(openPreviewSelector).attr('href');

        // Check if a link URL is set. If not use the content id to display a preview
        if (link_url !== '#' && link_url.indexOf('http') >= 0) {
            $iframe.css('display', 'none');
            $modal.find('.modal-body').append(_generateContentInfoMarkup(link_url));
        } else if (link_url !== '#' && link_url.indexOf('http') < 0) {
            $iframe.css('display', 'block');
            $iframe.attr('src', jse.core.config.get('appUrl') + '/' + link_url);
        } else {
            $iframe.css('display', 'block');
            $iframe.attr('src', jse.core.config.get('appUrl') + '/admin/content_preview.php?coID=' + content_id);
        }

        // Display the preview modal
        $modal.modal('show');
    }

    /**
     * Generates HTML containing the external link information.
     *
     * @param {String} data Link.
     *
     * @return {String} Created HTML string.
     */
    function _generateContentInfoMarkup(data) {
        // Label phrases.
        var externalLinkInfo = jse.core.lang.translate('TEXT_EXTERNAL_LINK_INFO', 'content_manager');

        // Return markup.
        return '\n\t\t\t\t\t<div class="col-md-12">\n\t\t\t\t\t\t' + data + ' ' + externalLinkInfo + '\n\t\t\t\t\t</div>\n\t\t\t';
    }

    // --------------------------------------------------------------------
    // INITIALIZATION
    // --------------------------------------------------------------------

    module.init = function (done) {
        // Listen to click event on preview icon
        $this.on('click', openPreviewSelector, _onPreviewClick);

        // Finish initialization.
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
